/*
 * Decompiled with CFR 0.152.
 */
package net.pasterdream.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.pasterdream.PasterdreamMod;
import net.pasterdream.procedures.NbtNumberButton1Procedure;
import net.pasterdream.procedures.NbtNumberButton2Procedure;
import net.pasterdream.procedures.NbtNumberButton3Procedure;
import net.pasterdream.procedures.NbtNumberButton4Procedure;
import net.pasterdream.procedures.NbtNumberButton5Procedure;
import net.pasterdream.procedures.WorkshopAnvilPr0Procedure;
import net.pasterdream.world.inventory.WorkshopAnvilGuiMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorkshopAnvilGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public WorkshopAnvilGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public WorkshopAnvilGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(WorkshopAnvilGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(WorkshopAnvilGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            WorkshopAnvilGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = WorkshopAnvilGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            WorkshopAnvilPr0Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            NbtNumberButton1Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            NbtNumberButton2Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            NbtNumberButton3Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            NbtNumberButton4Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            NbtNumberButton5Procedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PasterdreamMod.addNetworkMessage(WorkshopAnvilGuiButtonMessage.class, WorkshopAnvilGuiButtonMessage::buffer, WorkshopAnvilGuiButtonMessage::new, WorkshopAnvilGuiButtonMessage::handler);
    }
}

